<?php
require 'config.php';
require 'Slim/Slim.php';

\Slim\Slim::registerAutoloader();
$app = new \Slim\Slim();

$app->post('/login','login');
$app->post('/register','register');
$app->post('/gethomepage','gethomepage');
$app->post('/getcategory','getcategory');
$app->post('/categoryfilter','categoryfilter');
$app->post('/placeorder','placeorder');
$app->post('/getnotification','getnotification');
$app->post('/fetchorder','fetchorder');
$app->post('/fetchorderdetail','fetchorderdetail');
$app->post('/sendmessage','sendmessage');
$app->post('/sendfeedback','sendfeedback');
$app->post('/searchproduct','searchproduct');
$app->post('/offers','offers');
$app->post('/getshipping','getshipping');
$app->post('/gettoken','gettoken');
$app->post('/getauth','getauth');
$app->post('/getauthstore','getauthstore');
$app->post('/registerstore','registerstore');
$app->post('/getmyorders','getmyorders');
$app->post('/getmyordersstore','getmyordersstore');
$app->post('/getdetails','getdetails');
$app->post('/getdetailsorders','getdetailsorders');
$app->post('/updateorderstatus','updateorderstatus');
$app->post('/updateorderstatusstore','updateorderstatusstore');

$app->post('/getstorehomepage','getstorehomepage');
$app->post('/getstorehomepageunlisted','getstorehomepageunlisted');
$app->post('/addtostore','addtostore');
$app->post('/changeproductstockstatus','changeproductstockstatus');
$app->post('/placeordershop','placeordershop');
$app->post('/fetchordershop','fetchordershop');
$app->post('/adddeliveryboy','adddeliveryboy');
$app->post('/updatestoreproduct','updatestoreproduct');
$app->run();

function register() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $db = getDB();
           
        $sql = "SELECT user_id,fname,email,mobile,address FROM users WHERE mobile=:mobile";
        $stmt = $db->prepare($sql);
        $stmt->bindParam("mobile", $data->mobile, PDO::PARAM_STR);
        $stmt->execute();
        $mainCount=$stmt->rowCount();
        if($mainCount==0)
        {
             $db = getDB();
           
            $sql = "SELECT id,shopcode FROM storemanager WHERE shopcode=:franchise";
            $stmt = $db->prepare($sql);
            $stmt->bindParam("franchise", $data->franchise, PDO::PARAM_STR);
            $stmt->execute();
            $mainCount=$stmt->rowCount();
            if($mainCount>0)
            {    
            try {
                
                $db = getDB();
                $userData ='';
                $sql = "INSERT INTO users(fname, email, mobile, password, address, franchise)VALUES(:fname,:email,:mobile, :password, :address, :franchise)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam("fname", $data->name,PDO::PARAM_STR);
                $stmt->bindParam("email", $data->email,PDO::PARAM_STR);
                $stmt->bindParam("mobile", $data->mobile,PDO::PARAM_STR);
                $stmt->bindParam("password", $data->password,PDO::PARAM_STR);
                $stmt->bindParam("address", $data->address,PDO::PARAM_STR);
                $stmt->bindParam("franchise", $data->franchise,PDO::PARAM_STR);
                $stmt->execute();
                 if($lastid = $db->lastInsertId()){
                        echo '{"userData": "registered"}';
                        $db = null;
                    } else {
                       echo '{"error":{"text":"Bad request"}}';
                    }
        
                       
                }
                catch(PDOException $e) {
                    echo '{"error":{"text":'. $e->getMessage() .'}}';
                }
            }
        else
        {
           echo '{"error":{"text":"Please Check Shopcode!"}}'; 
        }    
        
    }
    else
    {
       echo '{"error":{"text":"User Already Exists!"}}'; 
    }
}



function login() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    
    try {
        
        $db = getDB();
        $userData ='';
        $sql = "SELECT user_id,fname,email,mobile,address,parent_id,area,city, franchise FROM users WHERE mobile=:mobile and password=:password ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam("mobile", $data->mobile, PDO::PARAM_STR);
        $stmt->bindParam("password", $data->password, PDO::PARAM_STR);
        $stmt->execute();
        $mainCount=$stmt->rowCount();
        $userData = $stmt->fetch(PDO::FETCH_OBJ);
        
        if(!empty($userData))
        {
            $user_id=$userData->user_id;
            $userData->token = apiToken($user_id);
			$parent_id=$userData->parent_id;
        }
        
        $db = null;
         if($userData){
               $userData = json_encode($userData);
                echo '{"userData": ' .$userData . '}';
            } else {
               echo '{"error":{"text":"Please check mobile number and password"}}';
            }

           
    }
    catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}

function updatestoreproduct() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
	
	
            try {
                
                $db = getDB();
                $success ='';
                $sql = "update storeitems set store_price=:store_price,store_mrp=:store_mrp where item_id=:item_id and store_id=:store_id ";
                $stmt = $db->prepare($sql);
                $stmt->bindParam("item_id", $data->itemid,PDO::PARAM_STR);
                $stmt->bindParam("store_id", $data->storeid,PDO::PARAM_STR);
               
                $stmt->bindParam("store_price", $data->storeprice,PDO::PARAM_STR);
                $stmt->bindParam("store_mrp", $data->storemrp,PDO::PARAM_STR);
                
                $stmt->execute();
                echo '{"success": "Product upadted"}';
                }
                catch(PDOException $e) {
                    echo '{"error":{"text":'. $e->getMessage() .'}}';
                }
           
    }

function adddeliveryboy() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $token=$data->token;
    $dname=$data->cname;
    $dmobile=$data->cmobile;
    $shopcode=$data->shopcode;

    $systemToken=apiToken();
    try {
         
        if($systemToken == $token){
            $db = getDB();
            $sqlorder = "INSERT INTO deliveryboy(dname, dmobile, dusername, dpassword, shopcode)VALUES(:dname, :dmobile, :dmobile, :dmobile, :shopcode)";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam("dname", $dname,PDO::PARAM_STR);
            $stmtorder->bindParam("dmobile", $dmobile,PDO::PARAM_STR);
            $stmtorder->bindParam("dusername", $dmobile,PDO::PARAM_STR);
            $stmtorder->bindParam("dpassword", $dmobile,PDO::PARAM_STR);
            $stmtorder->bindParam("shopcode", $shopcode,PDO::PARAM_STR);
            $stmtorder->execute();
            $lastid = $db->lastInsertId();

            $db = null;
            echo '{"success":"' . $lastid .'"}';
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}

function fetchordershop(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $userid=$data->user_id;
    $systemToken=apiToken();
    $ordertype="2";
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlorder = "SELECT orderid, user_id, fname, mobile, city, area, address ,status, total, shipping, paymenttype, payid, coupon, couponprice, lat, lng, dtype, dcode, driverid, dname, dmobile, ordertime FROM orders LEFT JOIN deliveryboy on orders.driverid = deliveryboy.id where orders.user_id = :userid and ordertype=:ordertype ORDER BY orderid DESC";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("userid",$userid, PDO::PARAM_STR);
            $stmtOrder->bindParam("ordertype",$ordertype, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderData = $stmtOrder->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"OrderData": ' . json_encode($OrderData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function placeordershop() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $token=$data->token;
    $user_id=$data->user_id;
    $fname=$data->fname;
    $city=$data->city; 
    $area=$data->area; 
    $mobile=$data->mobile;
    $address=$data->address;
    $coupon=$data->coupon;
    $couponprice=$data->couponprice;
    $paytype=$data->ptype;
    $payid=$data->payid;

    $dtype=$data->dtype;
    $lat = $data->lat;
    $lng = $data->lng;

    $total=$data->total;
    $shipping=$data->shipping;

    $orderitems=$data->items;
    $ordertype="2";
    $systemToken=apiToken();
    try {
         
        if($systemToken == $token){
            $db = getDB();
            $sqlorder = "INSERT INTO orders(user_id, fname, city, area, address, mobile, paymenttype, payid, total, shipping, coupon, couponprice, dtype, lat, lng,ordertype)VALUES(:userid, :fname, :city, :area, :address, :mobile, :paymenttype, :payid, :total, :shipping, :coupon, :couponprice, :dtype, :lat, :lng,:ordertype)";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam("fname", $fname,PDO::PARAM_STR);
            $stmtorder->bindParam("userid", $user_id,PDO::PARAM_STR);
            $stmtorder->bindParam("mobile", $mobile,PDO::PARAM_STR);
            $stmtorder->bindParam("city", $city,PDO::PARAM_STR);
            $stmtorder->bindParam("area", $area,PDO::PARAM_STR);
            $stmtorder->bindParam("address", $address,PDO::PARAM_STR);
            $stmtorder->bindParam("paymenttype", $paytype,PDO::PARAM_STR);
            $stmtorder->bindParam("payid", $payid,PDO::PARAM_STR);
            $stmtorder->bindParam("total", $total,PDO::PARAM_STR);
            $stmtorder->bindParam("shipping", $shipping,PDO::PARAM_STR);
            $stmtorder->bindParam("dtype", $dtype,PDO::PARAM_STR);
            $stmtorder->bindParam("lat", $lat,PDO::PARAM_STR);
            $stmtorder->bindParam("lng", $lng,PDO::PARAM_STR);
            $stmtorder->bindParam("coupon", $coupon,PDO::PARAM_STR);
            $stmtorder->bindParam("couponprice", $couponprice,PDO::PARAM_STR);
            $stmtorder->bindParam("ordertype", $ordertype,PDO::PARAM_STR);
            $stmtorder->execute();
            $lastid = $db->lastInsertId();

            foreach ($orderitems as $orderitem) {

                $itemname = $orderitem->itemname;
                $itemquantity = $orderitem->itemquantity;
                $itemquantitytype = $orderitem->itemquantitytype;
                $itemprice = $orderitem->itemprice;
                $itemtotal = $orderitem->itemtotal;
                $itemMquantity = $orderitem->Mquantity;

                $sqlitem = "INSERT INTO orderslist (orderid,itemname,itemquantity,itemquantitytype, Mquantity, itemprice,itemtotal) VALUES (:orderid,:itemname,:itemquantity,:itemquantitytype, :Mquantity, :itemprice,:itemtotal)";   
                $stmtitem = $db->prepare($sqlitem);
                $stmtitem->bindParam("orderid", $lastid, PDO::PARAM_STR);
                $stmtitem->bindParam("itemname", $itemname, PDO::PARAM_STR);
                $stmtitem->bindParam("itemquantity",$itemquantity, PDO::PARAM_INT);
                $stmtitem->bindParam("itemquantitytype",$itemquantitytype, PDO::PARAM_STR);
                $stmtitem->bindParam("Mquantity",$itemMquantity, PDO::PARAM_STR);
                $stmtitem->bindParam("itemprice", $itemprice, PDO::PARAM_INT);
                $stmtitem->bindParam("itemtotal", $itemtotal, PDO::PARAM_INT);
                $stmtitem->execute();
          }  
            $db = null;
            echo '{"success":"' . $lastid .'"}';
            
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}


function changeproductstockstatus() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
	
	
            try {
                
                $db = getDB();
                $success ='';
                $sql = "update storeitems set instock=:instock where item_id=:item_id and store_id=:store_id ";
                $stmt = $db->prepare($sql);
                $stmt->bindParam("item_id", $data->itemid,PDO::PARAM_STR);
                $stmt->bindParam("store_id", $data->storeid,PDO::PARAM_STR);
                $stmt->bindParam("instock", $data->instock,PDO::PARAM_STR);
                $stmt->execute();
                echo '{"success": "Product stock status upadted"}';
                }
                catch(PDOException $e) {
                    echo '{"error":{"text":'. $e->getMessage() .'}}';
                }
           
    }

function addtostore() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
	$homepage='YES';
	$offer='YES';
	$instock='NO';
	
            try {
                
                $db = getDB();
                $success ='';
                $sql = "INSERT INTO storeitems(item_id, store_id, store_price, store_mrp, homepage, offer,instock)VALUES(:item_id,:store_id,:store_price, :store_mrp, :homepage, :offer, :instock)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam("item_id", $data->itemid,PDO::PARAM_STR);
                $stmt->bindParam("store_id", $data->storeid,PDO::PARAM_STR);
                $stmt->bindParam("store_price", $data->storeprice,PDO::PARAM_STR);
                $stmt->bindParam("store_mrp", $data->storemrp,PDO::PARAM_STR);
                $stmt->bindParam("homepage", $homepage,PDO::PARAM_STR);
                $stmt->bindParam("offer", $offer,PDO::PARAM_STR);
                $stmt->bindParam("instock", $instock,PDO::PARAM_STR);
                $stmt->execute();
                 if($lastid = $db->lastInsertId()){
                        echo '{"success": "Product added to store"}';
                        $db = null;
                    } else {
                       echo '{"error":{"text":"Bad request"}}';
                    }
        
                       
                }
                catch(PDOException $e) {
                    echo '{"error":{"text":'. $e->getMessage() .'}}';
                }
           
    }
    

function getstorehomepageunlisted(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    $homepage = "YES";
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT items.id as id,name,category,description,price,mrp,quantity,quantitytype,image,items.homepage,items.offer,items.instock FROM items where id NOT IN (select item_id as id from storeitems,storemanager WHERE shopcode=:franchise and storemanager.id=storeitems.store_id)";
            $stmthome = $db->prepare($sqlhome);
            $stmthome->bindParam("franchise",$data->franchise, PDO::PARAM_STR);
           // $stmthome->bindParam("homepage",$homepage, PDO::PARAM_STR);
            $stmthome->execute();
            $tempData = $stmthome->rowCount();
            if($tempData==0)
            {
               $sqlhome = "SELECT id,name,category,description,price,mrp,quantity,quantitytype,image, homepage,offer,instock FROM items";
            $stmthome = $db->prepare($sqlhome);
            
            $stmthome->execute(); 
            }
            $homeData = $stmthome->fetchAll(PDO::FETCH_OBJ);

            $sqlcate = "SELECT * FROM category";
            $stmtCate = $db->prepare($sqlcate);
            $stmtCate->execute();
            $catetempData = $stmtCate->rowCount();
            $CateData = $stmtCate->fetchAll(PDO::FETCH_OBJ);
            
            $sqlbanner = "SELECT * FROM banner ORDER BY rand()";
            $stmtbanner = $db->prepare($sqlbanner);
            $stmtbanner->execute();
            $bannertempData = $stmtbanner->rowCount();
            $bannerData = $stmtbanner->fetchAll(PDO::FETCH_OBJ);
            
            $db = null;

            echo '{
                "HomeData": '. json_encode($homeData) .' ,
                "TempData": '. json_encode($tempData) .' ,
                "CateData": '. json_encode($CateData) .' ,
                "BannData": '. json_encode($bannerData) .' 
            }';
                }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 
}

function getstorehomepage(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    $homepage = "YES";
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT items.id as id,name,category,description,store_price as price,store_mrp as mrp,quantity,quantitytype,image,storeitems.homepage,storeitems.offer,storeitems.instock FROM items,storeitems,storemanager WHERE shopcode=:franchise and storemanager.id=storeitems.store_id and storeitems.item_id=items.id and storeitems.homepage = :homepage  ORDER BY id asc";
            $stmthome = $db->prepare($sqlhome);
            $stmthome->bindParam("franchise",$data->franchise, PDO::PARAM_STR);
            $stmthome->bindParam("homepage",$homepage, PDO::PARAM_STR);
            $stmthome->execute();
            $tempData = $stmthome->rowCount();
            $homeData = $stmthome->fetchAll(PDO::FETCH_OBJ);

            $sqlcate = "SELECT * FROM category";
            $stmtCate = $db->prepare($sqlcate);
            $stmtCate->execute();
            $catetempData = $stmtCate->rowCount();
            $CateData = $stmtCate->fetchAll(PDO::FETCH_OBJ);
            
            $sqlbanner = "SELECT * FROM banner ORDER BY rand()";
            $stmtbanner = $db->prepare($sqlbanner);
            $stmtbanner->execute();
            $bannertempData = $stmtbanner->rowCount();
            $bannerData = $stmtbanner->fetchAll(PDO::FETCH_OBJ);
            
            $db = null;

            echo '{
                "HomeData": '. json_encode($homeData) .' ,
                "TempData": '. json_encode($tempData) .' ,
                "CateData": '. json_encode($CateData) .' ,
                "BannData": '. json_encode($bannerData) .' 
            }';
                }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 
}

function gethomepage(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    $homepage = "YES";
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT items.id as id,name,category,description,store_price as price,store_mrp as mrp,quantity,quantitytype,image,storeitems.homepage,storeitems.offer,storeitems.instock FROM items,storeitems,storemanager WHERE shopcode=:franchise and storemanager.id=storeitems.store_id and storeitems.item_id=items.id and storeitems.homepage = :homepage  ORDER BY id asc";
            $stmthome = $db->prepare($sqlhome);
            $stmthome->bindParam("franchise",$data->franchise, PDO::PARAM_STR);
            $stmthome->bindParam("homepage",$homepage, PDO::PARAM_STR);
            $stmthome->execute();
            $tempData = $stmthome->rowCount();
            $homeData = $stmthome->fetchAll(PDO::FETCH_OBJ);

            $sqlcate = "SELECT * FROM category";
            $stmtCate = $db->prepare($sqlcate);
            $stmtCate->execute();
            $catetempData = $stmtCate->rowCount();
            $CateData = $stmtCate->fetchAll(PDO::FETCH_OBJ);
            
            $sqlbanner = "SELECT * FROM banner ORDER BY rand()";
            $stmtbanner = $db->prepare($sqlbanner);
            $stmtbanner->execute();
            $bannertempData = $stmtbanner->rowCount();
            $bannerData = $stmtbanner->fetchAll(PDO::FETCH_OBJ);
            
            $db = null;

            echo '{
                "HomeData": '. json_encode($homeData) .' ,
                "CateData": '. json_encode($CateData) .' ,
                "BannData": '. json_encode($bannerData) .' 
            }';
                }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 
}

function getcategory(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT * FROM category";
            $stmthome = $db->prepare($sqlhome);
            $stmthome->execute();
            $Data = $stmthome->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"Data": ' . json_encode($Data) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}


function getnotification(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT * FROM notification ORDER BY id DESC";
            $stmthome = $db->prepare($sqlhome);
            $stmthome->execute();
            $NotiData = $stmthome->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"NotiData": ' . json_encode($NotiData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}


function fetchorder(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $userid=$data->user_id;
    $systemToken=apiToken();
     $ordertype="1";
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlorder = "SELECT orderid, user_id, fname, mobile, city, area, address ,status, total, shipping, paymenttype, payid, coupon, couponprice, lat, lng, dtype, dcode, driverid, dname, dmobile, ordertime FROM orders LEFT JOIN deliveryboy on orders.driverid = deliveryboy.id where orders.user_id = :userid and ordertype=:ordertype ORDER BY orderid DESC";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("userid",$userid, PDO::PARAM_STR);
             $stmtOrder->bindParam("ordertype",$ordertype, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderData = $stmtOrder->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"OrderData": ' . json_encode($OrderData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function fetchorderdetail(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $orderid=$data->orderid;
    $systemToken=apiToken();
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlorder = "SELECT * FROM orderslist WHERE orderid = :orderid";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("orderid",$orderid, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderDetail = $stmtOrder->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"OrderDetail": ' . json_encode($OrderDetail) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function categoryfilter(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $category=$data->category;
    $systemToken=apiToken();
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT items.id as id,name,category,description,store_price as price,store_mrp as mrp,quantity,quantitytype,image,storeitems.homepage,storeitems.offer,storeitems.instock FROM items,storeitems,storemanager WHERE shopcode=:franchise and storemanager.id=storeitems.store_id and storeitems.item_id=items.id and category = :category";
            $stmthome = $db->prepare($sqlhome);
            $stmthome->bindParam("franchise",$data->franchise, PDO::PARAM_STR);
            $stmthome->bindParam("category",$category, PDO::PARAM_STR);
            $stmthome->execute();
            $tempData = $stmthome->rowCount();
            $homeData = $stmthome->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"CateFilterData": ' . json_encode($homeData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function offers(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    $offers = "YES";
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlhome = "SELECT items.id as id,name,category,description,store_price as price,store_mrp as mrp,quantity,quantitytype,image,storeitems.homepage,storeitems.offer,storeitems.instock FROM items,storeitems,storemanager WHERE shopcode=:franchise and storemanager.id=storeitems.store_id and storeitems.item_id=items.id and storeitems.offer = :offers";
            $stmthome = $db->prepare($sqlhome);
             $stmthome->bindParam("franchise",$data->franchise, PDO::PARAM_STR);
            $stmthome->bindParam("offers",$offers, PDO::PARAM_STR);
            $stmthome->execute();
            $tempData = $stmthome->rowCount();
            $homeData = $stmthome->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"offersData": ' . json_encode($homeData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function searchproduct(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $search=$data->squery;
    $systemToken=apiToken();
    
    try {
        if($token == $systemToken){
            $db = getDB();
            $sqlsearch = "SELECT items.id as id,name,category,description,store_price as price,store_mrp as mrp,quantity,quantitytype,image,storeitems.homepage,storeitems.offer,storeitems.instock FROM items,storeitems,storemanager WHERE shopcode=? and storemanager.id=storeitems.store_id and storeitems.item_id=items.id and name like ?";
            $params = array($data->franchise,"%$search%");
           // $stmtsearch->bindParam("franchise","1001", PDO::PARAM_STR);
            $stmtsearch = $db->prepare($sqlsearch);
            $stmtsearch->execute($params);
            $tempData = $stmtsearch->rowCount();
            $searchData = $stmtsearch->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"SearchData": ' . json_encode($searchData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function placeorder() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $token=$data->token;
    $user_id=$data->user_id;
    $fname=$data->fname;
    $city=$data->city; 
    $area=$data->area; 
    $mobile=$data->mobile;
    $address=$data->address;
    $coupon=$data->coupon;
    $couponprice=$data->couponprice;
    $paytype=$data->ptype;
    $payid=$data->payid;

    $dtype=$data->dtype;
    $lat = $data->lat;
    $lng = $data->lng;

    $total=$data->total;
    $shipping=$data->shipping;

    $orderitems=$data->items;
    $ordertype="1";
    $systemToken=apiToken();
    try {
         
        if($systemToken == $token){
            $db = getDB();
            $sqlorder = "INSERT INTO orders(user_id, fname, city, area, address, mobile, paymenttype, payid, total, shipping, coupon, couponprice, dtype, lat, lng,ordertype)VALUES(:userid, :fname, :city, :area, :address, :mobile, :paymenttype, :payid, :total, :shipping, :coupon, :couponprice, :dtype, :lat, :lng,:ordertype)";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam("fname", $fname,PDO::PARAM_STR);
            $stmtorder->bindParam("userid", $user_id,PDO::PARAM_STR);
            $stmtorder->bindParam("mobile", $mobile,PDO::PARAM_STR);
            $stmtorder->bindParam("city", $city,PDO::PARAM_STR);
            $stmtorder->bindParam("area", $area,PDO::PARAM_STR);
            $stmtorder->bindParam("address", $address,PDO::PARAM_STR);
            $stmtorder->bindParam("paymenttype", $paytype,PDO::PARAM_STR);
            $stmtorder->bindParam("payid", $payid,PDO::PARAM_STR);
            $stmtorder->bindParam("total", $total,PDO::PARAM_STR);
            $stmtorder->bindParam("shipping", $shipping,PDO::PARAM_STR);
            $stmtorder->bindParam("dtype", $dtype,PDO::PARAM_STR);
            $stmtorder->bindParam("lat", $lat,PDO::PARAM_STR);
            $stmtorder->bindParam("lng", $lng,PDO::PARAM_STR);
            $stmtorder->bindParam("coupon", $coupon,PDO::PARAM_STR);
            $stmtorder->bindParam("couponprice", $couponprice,PDO::PARAM_STR);
            $stmtorder->bindParam("ordertype", $ordertype,PDO::PARAM_STR);
            $stmtorder->execute();
            $lastid = $db->lastInsertId();

            foreach ($orderitems as $orderitem) {

                $itemname = $orderitem->itemname;
                $itemquantity = $orderitem->itemquantity;
                $itemquantitytype = $orderitem->itemquantitytype;
                $itemprice = $orderitem->itemprice;
                $itemtotal = $orderitem->itemtotal;
                $itemMquantity = $orderitem->Mquantity;

                $sqlitem = "INSERT INTO orderslist (orderid,itemname,itemquantity,itemquantitytype, Mquantity, itemprice,itemtotal) VALUES (:orderid,:itemname,:itemquantity,:itemquantitytype, :Mquantity, :itemprice,:itemtotal)";   
                $stmtitem = $db->prepare($sqlitem);
                $stmtitem->bindParam("orderid", $lastid, PDO::PARAM_STR);
                $stmtitem->bindParam("itemname", $itemname, PDO::PARAM_STR);
                $stmtitem->bindParam("itemquantity",$itemquantity, PDO::PARAM_INT);
                $stmtitem->bindParam("itemquantitytype",$itemquantitytype, PDO::PARAM_STR);
                $stmtitem->bindParam("Mquantity",$itemMquantity, PDO::PARAM_STR);
                $stmtitem->bindParam("itemprice", $itemprice, PDO::PARAM_INT);
                $stmtitem->bindParam("itemtotal", $itemtotal, PDO::PARAM_INT);
                $stmtitem->execute();
          }  
            $db = null;
            echo '{"success":"' . $lastid .'"}';
            
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}



function sendmessage() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $token=$data->token;
    $cname=$data->cname;
    $cmobile=$data->cmobile;
    $cmsg=$data->cmsg;

    $systemToken=apiToken();
    try {
         
        if($systemToken == $token){
            $db = getDB();
            $sqlorder = "INSERT INTO message(cname, cmobile, cmsg)VALUES(:cname,:cmobile,:cmessage)";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam("cname", $cname,PDO::PARAM_STR);
            $stmtorder->bindParam("cmobile", $cmobile,PDO::PARAM_STR);
            $stmtorder->bindParam("cmessage", $cmsg,PDO::PARAM_STR);
            $stmtorder->execute();
            $lastid = $db->lastInsertId();

            $db = null;
            echo '{"success":"' . $lastid .'"}';
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}


function sendfeedback() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $token=$data->token;
    $fmsg=$data->fmsg;

    $systemToken=apiToken();
    try {
         
        if($systemToken == $token){
            $db = getDB();
            $sqlorder = "INSERT INTO feedback(fmsg)VALUES(:fmessage)";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam("fmessage", $fmsg,PDO::PARAM_STR);
            $stmtorder->execute();
            $lastid = $db->lastInsertId();
            $db = null;
            echo '{"success":"' . $lastid .'"}';
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}


function getshipping(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $token=$data->token;
    $systemToken=apiToken();
    $amount=$data->amount;
    
    $shipcost = 0;

    try {
        if($token == $systemToken){
            $db = getDB();
            $sql = "SELECT * FROM shipping";
            $stmt = $db->prepare($sql);
            $stmt->execute();
            $Data = $stmt->fetchAll(PDO::FETCH_OBJ);
            $db = null;

            $db = getDB();
            $sql = "SELECT * FROM coupons";
            $stmt = $db->prepare($sql);
            $stmt->execute();
            $Coupons = $stmt->fetchAll(PDO::FETCH_OBJ);
            $db = null;

            foreach($Data as $data){
                if($data->amount >= $amount){
                    $shipcost = $data->shipcost;
                    break;
                }else{
                    $shipcost = 0;
                }
            }

            echo '{
                "shipCost": ' . $shipcost . ',
                "coupons": '. json_encode($Coupons) .' 
            }';

            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}


function gettoken(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $systemToken=apiToken();
    echo $systemToken;

}

function getauth() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    
    try {
        
        $db = getDB();
        $userData ='';
        $sql = "SELECT id,dmobile,dname,dusername FROM deliveryboy WHERE dusername=:username and dpassword=:password ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam("username", $data->username, PDO::PARAM_STR);
        $stmt->bindParam("password", $data->password, PDO::PARAM_STR);
        $stmt->execute();
        $mainCount=$stmt->rowCount();
        $userData = $stmt->fetch(PDO::FETCH_OBJ);
        
        $db = null;
         if($userData){
               $userData = json_encode($userData);
                echo '{"userData": ' .$userData . '}';
            } else {
               echo '{"error":{"text":"Bad request"}}';
            }

           
    }
    catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}

function registerstore() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $db = getDB(); 
    $sql = "SELECT shopcode, sname, storename, smobile, saddress, susername,spassword FROM storemanager WHERE smobile=:smobile or shopcode=:shopcode or susername=:susername";
        $stmt = $db->prepare($sql);
        $stmt->bindParam("smobile", $data->smobile,PDO::PARAM_STR);
        $stmt->bindParam("shopcode", $data->shopcode,PDO::PARAM_STR);
         $stmt->bindParam("susername", $data->susername,PDO::PARAM_STR);
        $stmt->execute();
        $mainCount=$stmt->rowCount();
        if($mainCount==0)
        {
    
            try {
                
                $db = getDB();
                $userData ='';
                $sql = "INSERT INTO storemanager(shopcode, sname, storename, smobile, saddress, susername,spassword)VALUES(:shopcode, :sname, :storename, :smobile, :saddress, :susername, :spassword)";
                $stmt = $db->prepare($sql);
                $stmt->bindParam("shopcode", $data->shopcode,PDO::PARAM_STR);
                $stmt->bindParam("sname", $data->sname,PDO::PARAM_STR);
                $stmt->bindParam("storename", $data->storename,PDO::PARAM_STR);
                $stmt->bindParam("smobile", $data->smobile,PDO::PARAM_STR);
                $stmt->bindParam("saddress", $data->saddress,PDO::PARAM_STR);
                $stmt->bindParam("susername", $data->susername,PDO::PARAM_STR);
                $stmt->bindParam("spassword", $data->spassword,PDO::PARAM_STR);
                $stmt->execute();
               $db = null;
                        echo '{"userData": "registered"}';
                   
        
                   
            }
            catch(PDOException $e) {
                echo '{"error":{"text":here'. $e->getMessage() .'}}';
            }
    
        }
         else
    {
       echo '{"error":"Shop Already Exists, Please check mobile number, username and shopcode!"}'; 
    }
        
}

function getauthstore() {
    
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    
    try {
        
        $db = getDB();
        $userData ='';
        $sql = "SELECT id,smobile,sname as fname,susername,shopcode  as franchise,storename,saddress,area,city FROM storemanager WHERE susername=:username and spassword=:password ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam("username", $data->username, PDO::PARAM_STR);
        $stmt->bindParam("password", $data->password, PDO::PARAM_STR);
        $stmt->execute();
        $mainCount=$stmt->rowCount();
        $userData = $stmt->fetch(PDO::FETCH_OBJ);
        
        $db = null;
         if($userData){
               $userData = json_encode($userData);
                echo '{"userData": ' .$userData . '}';
            } else {
               echo '{"error":{"text":"Bad request"}}';
            }

           
    }
    catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}


function getmyorders(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $userid=$data->id;
    
    try {
        if(true){
            $db = getDB();
            $sqlorder = "SELECT orderid, user_id, fname, mobile, city, area, address ,status, total, shipping, paymenttype, payid, coupon, couponprice, lat, lng, dtype, dcode, driverid, dname, dmobile, ordertime FROM orders LEFT JOIN deliveryboy on orders.driverid = deliveryboy.id where orders.driverid = :userid ORDER BY orderid DESC";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("userid",$userid, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderData = $stmtOrder->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"OrderData": ' . json_encode($OrderData) . '}';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}


function getmyordersstore(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $userid=$data->id;
    $shopcode=$data->shopcode;
    
    try {
        if(true){
            $db = getDB();
            $sqlorder = "SELECT orders.orderid, orders.user_id, orders.fname, orders.mobile, orders.city, orders.area, orders.address, orders.status, orders.total, orders.shipping, orders.paymenttype, orders.payid, orders.coupon, orders.couponprice, orders.lat, orders.lng, orders.dtype, orders.dcode, orders.driverid, orders.ordertime, deliveryboy.dname,deliveryboy.id,deliveryboy.dmobile FROM users,storemanager,orders LEFT JOIN deliveryboy on deliveryboy.id = orders.driverid where orders.user_id=users.user_id and users.franchise=storemanager.shopcode and storemanager.shopcode=:shopcode  ORDER BY orderid DESC";
            $stmtOrder = $db->prepare($sqlorder);
             $stmtOrder->bindParam("shopcode", $shopcode, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderData = $stmtOrder->fetchAll(PDO::FETCH_OBJ);
            $db = null;
            echo '{"OrderData": ' . json_encode($OrderData) . '}';
            }
            else{
                echo '{"error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function getdetails(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $userid=$data->id;
    $orderid=$data->orderid;
    
    try {
        if(true){
            $db = getDB();
            $sqlorder = "SELECT orderid, user_id, fname, mobile, city, area, address ,status, total, shipping, paymenttype, payid, coupon, couponprice, lat, lng, dtype, dcode, driverid, dname, dmobile, ordertime FROM orders LEFT JOIN deliveryboy on orders.driverid = deliveryboy.id where orders.orderid = :orderid ORDER BY orderid DESC";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("orderid",$orderid, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderData = $stmtOrder->fetch(PDO::FETCH_OBJ);
            $db = null;

            $db = getDB();
            $sqlorder = "SELECT * FROM orderslist WHERE orderid = :orderid";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("orderid",$orderid, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderDetail = $stmtOrder->fetchAll(PDO::FETCH_OBJ);
            $db = null;

            echo '{
                    "OrderData": ' . json_encode($OrderData) . ',
                    "OrderDetail": ' . json_encode($OrderDetail) . '
                    }';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}


function getdetailsorders(){

    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());
    $userid=$data->id;
    $orderid=$data->orderid;
    $shopcode=$data->shopcode;
    
    try {
        if(true){
            $db = getDB();
            $sqlorder = "SELECT orderid, user_id, fname, mobile, city, area, address ,status, total, shipping, paymenttype, payid, coupon, couponprice, lat, lng, dtype, dcode, driverid, dname, dmobile, ordertime FROM orders LEFT JOIN deliveryboy on orders.driverid = deliveryboy.id where orders.orderid = :orderid ORDER BY orderid DESC";
            $stmtOrder = $db->prepare($sqlorder);
            $stmtOrder->bindParam("orderid",$orderid, PDO::PARAM_STR);
            $stmtOrder->execute();
            $OrderData = $stmtOrder->fetch(PDO::FETCH_OBJ);
            $db = null;

            $db = getDB();
            $sql = "SELECT dname, id FROM deliveryboy where shopcode=:shopcode";
            $stmt = $db->prepare($sql);
            $stmt->bindParam("shopcode",$shopcode, PDO::PARAM_STR);
            $stmt->execute();
            $ddata = $stmt->fetchAll(PDO::FETCH_OBJ);
            $db = null;

            echo '{
                    "OrderData": ' . json_encode($OrderData) . ',
                    "ddata": ' . json_encode($ddata) . '
                    }';
            }
            else{
                echo '{"Error":"Error"}'; 
        }
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    } 

}

function updateorderstatus() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $orderid=$data->orderid;
    $status='Delivered';

    $systemToken=apiToken();
    try {
         
        if(true){
            $db = getDB();
            $sqlorder = "UPDATE orders SET status=:status WHERE orderid=:orderid";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam(":orderid", $orderid,PDO::PARAM_STR);
            $stmtorder->bindParam(":status", $status,PDO::PARAM_STR);
            
            if($stmtorder->execute()){
                echo '{"status":"success"}';
            }else{
                echo '{"error":{"text":"No access"}}';
            }
            $db = null;
           
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}


function updateorderstatusstore() {
    $request = \Slim\Slim::getInstance()->request();
    $data = json_decode($request->getBody());

    $orderid=$data->orderid;
    $status=$data->status;
    $driver=$data->deliveryboy;
    $dcode = rand(1111,9999);

    $systemToken=apiToken();
    try {
         
        if(true){
            $db = getDB();
            $sqlorder = "UPDATE orders SET status=:status, driverid=:driver, dcode=:dcode WHERE orderid=:orderid";
            $stmtorder = $db->prepare($sqlorder);
            $stmtorder->bindParam(":orderid", $orderid,PDO::PARAM_STR);
            $stmtorder->bindParam(":status", $status,PDO::PARAM_STR);
            $stmtorder->bindParam(":driver", $driver,PDO::PARAM_STR);
            $stmtorder->bindParam(":dcode", $dcode,PDO::PARAM_STR);
            if($stmtorder->execute()){
                echo '{"status":"success"}';
            }else{
                echo '{"error":{"text":"No access"}}';
            }
            $db = null;
           
        } else{
            echo '{"error":{"text":"No access"}}';
        }
       
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}';
    }
}
?>